﻿using System;
using System.IO;
using System.ServiceModel;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Client;
using Microsoft.Xrm.Sdk.Metadata;
using Microsoft.Xrm.Sdk.Messages;
using Microsoft.Xrm.Sdk.Query;
using System.Threading;
using System.Web;

namespace MCSUtilities2011
{
    public class UtilityFunctions
    {
        
        private IOrganizationService _service;
        public IOrganizationService setService
        {
            set { _service = value; }
        }
        private MCSLogger _logger;
        public MCSLogger setlogger
        {
            set { _logger = value; }
        }
        public int getOptionSetValue(string optionSetString, string entityName, string attributeName)
        {
            try
            {
                int returnInt = 0;
                RetrieveAttributeRequest attributeRequest = new RetrieveAttributeRequest();
                attributeRequest.EntityLogicalName = entityName;
                attributeRequest.LogicalName = attributeName;
                // Retrieve only the currently published changes, ignoring the changes that have
                // not been published.
                attributeRequest.RetrieveAsIfPublished = false;

                RetrieveAttributeResponse attributeResponse = (RetrieveAttributeResponse)_service.Execute(attributeRequest);

                // Access the retrieved attribute.
                PicklistAttributeMetadata retrievedAttributeMetadata = (PicklistAttributeMetadata)attributeResponse.AttributeMetadata;
                for (int i = 0; i < retrievedAttributeMetadata.OptionSet.Options.Count; i++)
                {
                    if (retrievedAttributeMetadata.OptionSet.Options[i].Label.LocalizedLabels[0].Label == optionSetString)
                    {
                        returnInt = retrievedAttributeMetadata.OptionSet.Options[i].Value.Value;
                        break;
                    }

                }
                return returnInt;
            }
            catch (FaultException<OrganizationServiceFault> ex)
            {
                _logger.setService = _service;
                _logger.setModule = "getOptionSetValue";
                _logger.WriteToFile(ex.Detail.Message);
                _logger.setModule = "execute";
                return 0;
            }
            catch (Exception ex)
            {
                _logger.setService = _service;
                _logger.setModule = "getOptionSetValue";
                _logger.WriteToFile(ex.Message);
                _logger.setModule = "execute";
                return 0;
            }
        }
        public string getOptionSetString(int optionSetValue, string entityName, string attributeName)
        {
            try
            {

                string optionSetString = string.Empty;

                RetrieveAttributeRequest attributeRequest = new RetrieveAttributeRequest();
                attributeRequest.EntityLogicalName = entityName;
                attributeRequest.LogicalName = attributeName;
                // Retrieve only the currently published changes, ignoring the changes that have
                // not been published.
                attributeRequest.RetrieveAsIfPublished = true;

                RetrieveAttributeResponse attributeResponse = (RetrieveAttributeResponse)_service.Execute(attributeRequest);

                // Access the retrieved attribute.
                PicklistAttributeMetadata retrievedAttributeMetadata = (PicklistAttributeMetadata)attributeResponse.AttributeMetadata;
                for (int i = 0; i < retrievedAttributeMetadata.OptionSet.Options.Count; i++)
                {
                    if (retrievedAttributeMetadata.OptionSet.Options[i].Value == optionSetValue)
                    {
                        optionSetString = retrievedAttributeMetadata.OptionSet.Options[i].Label.LocalizedLabels[0].Label;
                        break;
                    }

                }
                return optionSetString;
            }
            catch (FaultException<OrganizationServiceFault> ex)
            {
                _logger.setService = _service;
                _logger.setModule = "getOptionSetString";
                _logger.WriteToFile(ex.Detail.Message);
                _logger.setModule = "execute";
                return null;
            }
            catch (Exception ex)
            {
                _logger.setService = _service;
                _logger.setModule = "getOptionSetString";
                _logger.WriteToFile(ex.Message);
                _logger.setModule = "execute";
                return null;
            }
        }
    }
    public class LogSettings
    {
        public string Org { get; set; }
        public string ConfigFieldName { get; set; }
        public Guid UserId { get; set; }
    }
    #region Log Messages

    public class CreateCRMLogEntryRequest
    {
        public string MessageId { get; set; }

        public string OrganizationName { get; set; }

        public Guid UserId { get; set; }

        public int crme_Sequence { get; set; }

        public string crme_Name { get; set; }

        public string NameofDebugSettingsField { get; set; }

        public string crme_ErrorMessage { get; set; }

        public string crme_Method { get; set; }

        public bool crme_GranularTiming { get; set; }

        public bool crme_TransactionTiming { get; set; }

        public bool crme_Debug { get; set; }

        public int crme_LogLevel { get; set; }

        public Guid crme_RelatedParentId { get; set; }

        public string crme_RelatedParentEntityName { get; set; }

        public string crme_RelatedParentFieldName { get; set; }

        public string crme_RelatedWebMethodName { get; set; }

        public string crme_TimeStart { get; set; }

        public string crme_TimeEnd { get; set; }

        public Decimal crme_Duration { get; set; }
    }

    public class CreateCRMLogEntryResponse
    {
        public string MessageId { get; set; }
        public Guid crme_loggingId { get; set; }
    }



    #endregion
}
